<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class Popup {
        private $db;
        private $id;
        private $nome;
        private $immagine;
        private $testo;
        private $link;
        private $secondi;
        private $singoloContenuto;
        private $categoria;
       
        public function __construct($db, $id, $nome="", $immagine="", $testo="", $link="", $secondi="", $singoloContenuto="", $categoria=0) {
            $this->db       = $db;
            $this->id       = $id;
            $this->nome     = $nome;
            $this->immagine = $immagine;
            $this->testo    = $testo;
            $this->link     = $link;
            $this->secondi  = $secondi;
            $this->singoloContenuto = $singoloContenuto;
            $this->categoria        = $categoria;
        }

        function crea() {
            $dataOggi = date("Y-m-d H:m:s");
            $query ="INSERT INTO geec_popup VALUES(NULL,'$this->nome','$this->link','$this->immagine','$this->testo','$this->categoria','0','$this->secondi')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query    = "UPDATE geec_popup SET nome='$this->nome', testo='$this->testo', link='$this->link', categoria='$this->categoria', secondi='$this->secondi', singoloContenuto='0' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function cambiaImmagine($immagine) {
            $query    = "UPDATE geec_popup SET immagine='$immagine' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_popup",$this->id);
            
            // elimina le occorrenze in cui la form è presente, l'id di questo componente è 20
            $queryEliminaOccorrenzeComposizionePagine = "DELETE FROM geecB_composizionePagine WHERE idElemento = $this->id AND idComponente = 20";
            $this->db->eseguiQueryScrittura($queryEliminaOccorrenzeComposizionePagine);
        }
        
        function duplica($prefisso = "Copia di") {
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geec_popup WHERE id=$this->id");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geec_popup SELECT * FROM tabella_temporanea;");
            $idNuovaPopup = $this->db->idUltimoElemento();
            
            $this->db->eseguiQueryScrittura("UPDATE geec_popup SET nome = CONCAT('$prefisso', ' ', nome) WHERE id = $idNuovaPopup");
            return $idNuovaPopup;
        }
        
        function caricaDatiDalDatabase() {
            $datiPopup   = $this->db->leggiSingolaRiga("geec_popup",$this->id);
            $this->nome         = $datiPopup["nome"];
            $this->immagine     = $datiPopup["immagine"];
            $this->testo        = $datiPopup["testo"];
            $this->link         = $datiPopup["link"];
            $this->secondi      = $datiPopup["secondi"];
            $this->singoloContenuto = $datiPopup["singoloContenuto"];
            $this->categoria        = $datiPopup["categoria"];
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getImmagine() {
            return $this->immagine;
        }

        public function getTesto() {
            return $this->testo;
        }

        public function getLink() {
            return $this->link;
        }

        public function getSecondi() {
            return $this->secondi;
        }

        public function getSingoloContenuto() {
            return $this->singoloContenuto;
        }

        public function getCategoria() {
            return $this->categoria;
        }

        public function setDb($db) {
            $this->db = $db;
        }

        public function setId($id) {
            $this->id = $id;
        }

        public function setNome($nome) {
            $this->nome = $nome;
        }

        public function setImmagine($immagine) {
            $this->immagine = $immagine;
        }

        public function setTesto($testo) {
            $this->testo = $testo;
        }

        public function setLink($link) {
            $this->link = $link;
        }

        public function setSecondi($secondi) {
            $this->secondi = $secondi;
        }

        public function setSingoloContenuto($singoloContenuto) {
            $this->singoloContenuto = $singoloContenuto;
        }

        public function setCategoria($categoria) {
            $this->categoria = $categoria;
        }
    }